/*
 * Decompiled with CFR 0.152.
 */
package com.oxaion.tools.weblauncher.data;

import com.oxaion.tools.weblauncher.data.File;
import com.oxaion.tools.weblauncher.data.FileSystemWrapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Folder
implements FileSystemWrapper {
    private Map<String, Folder> folders = new HashMap<String, Folder>();
    private Map<String, File> files = new HashMap<String, File>();
    private String name;
    private Folder parent;

    public void addFile(File file) {
        this.files.put(file.getName(), file);
        file.setParent(this);
    }

    public void addFolder(Folder folder) {
        this.folders.put(folder.getName(), folder);
        folder.setParent(this);
    }

    public File getFile(String name) {
        return this.files.get(name);
    }

    public Folder getFolder(String name) {
        return this.folders.get(name);
    }

    @Override
    public String getPath() {
        StringBuffer path = new StringBuffer();
        if (this.parent != null) {
            path.append(this.parent.getPath());
            path.append("/");
            path.append(this.name);
        } else if (this.name != null) {
            path.append("/");
            path.append(this.name);
        }
        return path.toString();
    }

    @Override
    public String getURI() throws UnsupportedEncodingException {
        StringBuffer path = new StringBuffer();
        if (this.parent != null) {
            path.append(this.parent.getURI());
            path.append("/");
            path.append(URLEncoder.encode(this.name, "UTF-8"));
        } else if (this.name != null) {
            path.append("/");
            path.append(URLEncoder.encode(this.name, "UTF-8"));
        }
        return path.toString();
    }

    public List<File> findFilesToUpdate(Folder installedVersion) {
        ArrayList<File> updateFiles = new ArrayList<File>();
        for (File file : this.files.values()) {
            File installedFile = installedVersion.getFile(file.getName());
            if (installedFile != null && !file.isNewerThan(installedFile)) continue;
            updateFiles.add(file);
        }
        for (Folder folder : this.folders.values()) {
            if (installedVersion.getFolder(folder.getName()) == null) {
                updateFiles.addAll(folder.getAllSubFiles());
                continue;
            }
            updateFiles.addAll(folder.findFilesToUpdate(installedVersion.getFolder(folder.getName())));
        }
        return updateFiles;
    }

    public List<FileSystemWrapper> findFilesToDelete(Folder newVersion) {
        ArrayList<FileSystemWrapper> deleteFiles = new ArrayList<FileSystemWrapper>();
        for (File file : this.files.values()) {
            File newFile = newVersion.getFile(file.getName());
            if (newFile != null) continue;
            deleteFiles.add(file);
        }
        for (Folder folder : this.folders.values()) {
            if (newVersion.getFolder(folder.getName()) == null) {
                deleteFiles.add(folder);
                continue;
            }
            deleteFiles.addAll(folder.findFilesToDelete(newVersion.getFolder(folder.getName())));
        }
        return deleteFiles;
    }

    public List<File> getAllSubFiles() {
        ArrayList<File> subFiles = new ArrayList<File>();
        subFiles.addAll(this.files.values());
        for (Folder folder : this.folders.values()) {
            subFiles.addAll(folder.getAllSubFiles());
        }
        return subFiles;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Folder getParent() {
        return this.parent;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParent(Folder folder) {
        this.parent = folder;
    }

    public Collection<File> getFiles() {
        return this.files.values();
    }

    public Collection<Folder> getFolders() {
        return this.folders.values();
    }
}

