/*
 * Decompiled with CFR 0.152.
 */
package com.oxaion.tools.weblauncher.xml;

import com.oxaion.tools.weblauncher.data.File;
import com.oxaion.tools.weblauncher.data.Folder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FileVersionParser
extends DefaultHandler {
    private Folder root;
    private Folder currentFolder;
    private File currentFile;
    private StringBuffer currentBuffer = new StringBuffer();

    public Folder parse(InputSource input) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(input, (DefaultHandler)this);
        return this.root;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("root")) {
            this.currentFolder = this.root = new Folder();
        } else if (qName.equals("file")) {
            this.currentFile = new File();
        } else if (qName.equals("name") && this.currentFile != null) {
            this.currentBuffer = new StringBuffer();
        } else if (qName.equals("name") && this.currentFile == null) {
            this.currentBuffer = new StringBuffer();
        } else if (qName.equals("lastmodified")) {
            this.currentBuffer = new StringBuffer();
        } else if (qName.equals("size")) {
            this.currentBuffer = new StringBuffer();
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (qName.equals("file")) {
            this.currentFolder.addFile(this.currentFile);
            this.currentFile = null;
        } else if (qName.equals("folder")) {
            this.currentFolder = this.currentFolder.getParent();
        } else if (qName.equals("lastmodified")) {
            this.currentFile.setLastModified(Long.parseLong(this.currentBuffer.toString()));
        } else if (qName.equals("size")) {
            this.currentFile.setSize(Long.parseLong(this.currentBuffer.toString()));
        } else if (qName.equals("name") && this.currentFile != null) {
            String name = this.currentBuffer.toString();
            try {
                name = URLDecoder.decode(name, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.currentFile.setName(name);
        } else if (qName.equals("name") && this.currentFile == null) {
            Folder folder = new Folder();
            try {
                folder.setName(URLDecoder.decode(this.currentBuffer.toString(), "utf-8"));
            }
            catch (UnsupportedEncodingException uee) {
                folder.setName(this.currentBuffer.toString());
            }
            if (this.currentFolder.getFolder(folder.getName()) != null) {
                this.currentFolder = this.currentFolder.getFolder(folder.getName());
            } else {
                this.currentFolder.addFolder(folder);
                this.currentFolder = folder;
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.currentBuffer.append(buf, offset, len);
    }
}

